% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vartestClust.R
\name{vartestClust}
\alias{vartestClust}
\alias{vartestClust.default}
\alias{vartestClust.formula}
\title{Reweighted Test to Compare Two Variances in Clustered Data}
\usage{
vartestClust(x, ...)

\method{vartestClust}{default}(
  x,
  y,
  idx,
  idy,
  difference = 0,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)

\method{vartestClust}{formula}(formula, id, data, subset, na.action, ...)
}
\arguments{
\item{x, y}{numeric vectors of data values.}

\item{...}{further arguments to be passed to or from methods.}

\item{idx}{vector or factor object denoting cluster membership for \code{x} observations.
Length must be equal to length of \code{x}.}

\item{idy}{vector or factor object denoting cluster membership for \code{y} observations. Length must be equal
to length of \code{y}}

\item{difference}{the hypothesized difference of the marginal population variances of \code{x} and \code{y}.}

\item{alternative}{indicates the alternative hypothesis and must be one of "\code{two.sided}", "\code{greater}",
or "\code{less}".You can specify just the initial letter.}

\item{conf.level}{confidence level of the interval.}

\item{formula}{a formula of the form \code{lhs ~ rhs} where \code{lhs} is a numeric variable giving the data values and
\code{rhs} a factor with two levels giving the corresponding groups.}

\item{id}{a vector or factor giving the corresponding cluster membership.}

\item{data}{an optional matrix or data frame containing variables in the formula \code{formula} and \code{id}.
By default the variables are taken from \code{environment(formula)}.}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when data contain \code{NA}s. Defaults to
\code{getOption("na.action")}.}
}
\value{
A list with class "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value of the test.}
\item{conf.int}{a confidence interval for the difference of the population marginal variances.}
\item{estimate}{the difference in reweighted sample variances of \code{x} and \code{y}.}
\item{null.value}{the difference of population marginal variances under the null.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string indicating the test performed.}
\item{data.name}{a character string giving the name of the data and the total number of clusters.}
\item{M}{the number of clusters.}
}
\description{
Performs a reweighted test to compare marginal variances of intra-cluster groups in clustered data.
Appropriate for clustered data with cluster- or group-size informativeness.
}
\details{
The null hypothesis is that the difference of the marginal variances of the populations of
intra-cluster groups from which \code{x} and \code{y} were drawn is equal to \code{difference}.

Using the default method, \code{difference} is the difference of the reweighted sample variances of \code{x}
and \code{y}. When using the formula method, the order of the difference is determined by the order of the
factor levels of \code{rhs}.
}
\examples{
data(screen8)
boys <- subset(screen8, gender=='M')
girls <- subset(screen8, gender=='F')

## Do boys and girls have the same variability in math scores?
## Test using vectors
vartestClust(x=boys$math, y=girls$math, idx=boys$sch.id, idy=girls$sch.id)

## Test using formula method.
vartestClust(math~gender, id=sch.id, data=screen8)

## Note that in this example, the sign of the estimate returned when using the formula
## method is opposite to that when the test was performed using vectors. This is due to
## the order of the gender factor levels

}
\references{
Gregg, M., Marginal methods and software for clustered data with cluster- and group-size informativeness.
PhD dissertation, University of Louisville, 2020.
}
