// Generated by rstantools.  Do not edit by hand.

//=============================================================================
//
// Copyright (c) 2018-2019 Paul McKeigue, Marco Colombo and Athina Spiliopoulou
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//=============================================================================

#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.19.1
#include <stan/model/model_header.hpp>
namespace model_hs_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_hs");
    reader.add_event(10, 10, "include", "/chunks/hs.fun");
    reader.add_event(10, 0, "start", "/chunks/hs.fun");
    reader.add_event(44, 34, "end", "/chunks/hs.fun");
    reader.add_event(44, 11, "restart", "model_hs");
    reader.add_event(140, 105, "end", "model_hs");
    return reader;
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
hs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z,
       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& r1_local,
       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& r2_local,
       const T3__& r1_global,
       const T4__& r2_global, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 15;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z));
        current_statement_begin__ = 18;
        local_scalar_t__ tau(DUMMY_VAR__);
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau, DUMMY_VAR__);
        stan::math::assign(tau,(r1_global * stan::math::sqrt(r2_global)));
        current_statement_begin__ = 21;
        validate_non_negative_index("lambda", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda(K);
        stan::math::initialize(lambda, DUMMY_VAR__);
        stan::math::fill(lambda, DUMMY_VAR__);
        stan::math::assign(lambda,elt_multiply(r1_local, stan::math::sqrt(r2_local)));
        current_statement_begin__ = 24;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(elt_multiply(z, lambda), tau));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct hs_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z,
       const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& r1_local,
       const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& r2_local,
       const T3__& r1_global,
       const T4__& r2_global, std::ostream* pstream__) const {
        return hs(z, r1_local, r2_local, r1_global, r2_global, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type, Eigen::Dynamic, 1>
reg_hs(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z,
           const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& r1_local,
           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& r2_local,
           const T3__& r1_global,
           const T4__& r2_global,
           const T5__& global_scale,
           const T6__& c2, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 31;
        int K(0);
        (void) K;  // dummy to suppress unused var warning
        stan::math::fill(K, std::numeric_limits<int>::min());
        stan::math::assign(K,rows(z));
        current_statement_begin__ = 34;
        local_scalar_t__ tau(DUMMY_VAR__);
        (void) tau;  // dummy to suppress unused var warning
        stan::math::initialize(tau, DUMMY_VAR__);
        stan::math::fill(tau, DUMMY_VAR__);
        stan::math::assign(tau,((r1_global * stan::math::sqrt(r2_global)) * global_scale));
        current_statement_begin__ = 37;
        validate_non_negative_index("lambda2", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda2(K);
        stan::math::initialize(lambda2, DUMMY_VAR__);
        stan::math::fill(lambda2, DUMMY_VAR__);
        stan::math::assign(lambda2,square(elt_multiply(r1_local, stan::math::sqrt(r2_local))));
        current_statement_begin__ = 40;
        validate_non_negative_index("lambda_tilde", "K", K);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_tilde(K);
        stan::math::initialize(lambda_tilde, DUMMY_VAR__);
        stan::math::fill(lambda_tilde, DUMMY_VAR__);
        stan::math::assign(lambda_tilde,stan::math::sqrt(elt_divide(multiply(c2, lambda2), add(c2, multiply(pow(tau, 2), lambda2)))));
        current_statement_begin__ = 43;
        return stan::math::promote_scalar<fun_return_scalar_t__>(multiply(elt_multiply(z, lambda_tilde), tau));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct reg_hs_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& z,
           const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& r1_local,
           const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& r2_local,
           const T3__& r1_global,
           const T4__& r2_global,
           const T5__& global_scale,
           const T6__& c2, std::ostream* pstream__) const {
        return reg_hs(z, r1_local, r2_local, r1_global, r2_global, global_scale, c2, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_hs : public prob_grad {
private:
        int P;
        int U;
        int N;
        matrix_d X;
        vector_d y;
        double scale_u;
        int regularized;
        double nu;
        double global_scale;
        double global_df;
        double slab_scale;
        double slab_df;
public:
    model_hs(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_hs(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_hs_namespace::model_hs";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 50;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            current_statement_begin__ = 53;
            context__.validate_dims("data initialization", "U", "int", context__.to_vec());
            U = int(0);
            vals_i__ = context__.vals_i("U");
            pos__ = 0;
            U = vals_i__[pos__++];
            current_statement_begin__ = 56;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 59;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "P", P);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,P));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, P);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = P;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 62;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "vector_d", context__.to_vec(N));
            y = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 65;
            context__.validate_dims("data initialization", "scale_u", "double", context__.to_vec());
            scale_u = double(0);
            vals_r__ = context__.vals_r("scale_u");
            pos__ = 0;
            scale_u = vals_r__[pos__++];
            check_greater_or_equal(function__, "scale_u", scale_u, 0);
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "regularized", "int", context__.to_vec());
            regularized = int(0);
            vals_i__ = context__.vals_i("regularized");
            pos__ = 0;
            regularized = vals_i__[pos__++];
            check_greater_or_equal(function__, "regularized", regularized, 0);
            check_less_or_equal(function__, "regularized", regularized, 1);
            current_statement_begin__ = 71;
            context__.validate_dims("data initialization", "nu", "double", context__.to_vec());
            nu = double(0);
            vals_r__ = context__.vals_r("nu");
            pos__ = 0;
            nu = vals_r__[pos__++];
            check_greater_or_equal(function__, "nu", nu, 1);
            current_statement_begin__ = 74;
            context__.validate_dims("data initialization", "global_scale", "double", context__.to_vec());
            global_scale = double(0);
            vals_r__ = context__.vals_r("global_scale");
            pos__ = 0;
            global_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "global_scale", global_scale, 0);
            current_statement_begin__ = 77;
            context__.validate_dims("data initialization", "global_df", "double", context__.to_vec());
            global_df = double(0);
            vals_r__ = context__.vals_r("global_df");
            pos__ = 0;
            global_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "global_df", global_df, 1);
            current_statement_begin__ = 80;
            context__.validate_dims("data initialization", "slab_scale", "double", context__.to_vec());
            slab_scale = double(0);
            vals_r__ = context__.vals_r("slab_scale");
            pos__ = 0;
            slab_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "slab_scale", slab_scale, 0);
            current_statement_begin__ = 83;
            context__.validate_dims("data initialization", "slab_df", "double", context__.to_vec());
            slab_df = double(0);
            vals_r__ = context__.vals_r("slab_df");
            pos__ = 0;
            slab_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "slab_df", slab_df, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 89;
            validate_non_negative_index("beta_u", "U", U);
            num_params_r__ += U;
            current_statement_begin__ = 92;
            num_params_r__ += 1;
            current_statement_begin__ = 95;
            validate_non_negative_index("z", "(P - U)", (P - U));
            num_params_r__ += (P - U);
            current_statement_begin__ = 96;
            num_params_r__ += 1;
            current_statement_begin__ = 97;
            num_params_r__ += 1;
            current_statement_begin__ = 98;
            validate_non_negative_index("r1_local", "(P - U)", (P - U));
            num_params_r__ += (P - U);
            current_statement_begin__ = 99;
            validate_non_negative_index("r2_local", "(P - U)", (P - U));
            num_params_r__ += (P - U);
            current_statement_begin__ = 100;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_hs() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 89;
        if (!(context__.contains_r("beta_u")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_u missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_u");
        pos__ = 0U;
        validate_non_negative_index("beta_u", "U", U);
        context__.validate_dims("parameter initialization", "beta_u", "vector_d", context__.to_vec(U));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_u(U);
        size_t beta_u_j_1_max__ = U;
        for (size_t j_1__ = 0; j_1__ < beta_u_j_1_max__; ++j_1__) {
            beta_u(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_u);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_u: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 92;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 95;
        if (!(context__.contains_r("z")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable z missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("z");
        pos__ = 0U;
        validate_non_negative_index("z", "(P - U)", (P - U));
        context__.validate_dims("parameter initialization", "z", "vector_d", context__.to_vec((P - U)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> z((P - U));
        size_t z_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            z(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(z);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable z: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 96;
        if (!(context__.contains_r("r1_global")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable r1_global missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("r1_global");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "r1_global", "double", context__.to_vec());
        double r1_global(0);
        r1_global = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, r1_global);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable r1_global: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 97;
        if (!(context__.contains_r("r2_global")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable r2_global missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("r2_global");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "r2_global", "double", context__.to_vec());
        double r2_global(0);
        r2_global = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, r2_global);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable r2_global: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 98;
        if (!(context__.contains_r("r1_local")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable r1_local missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("r1_local");
        pos__ = 0U;
        validate_non_negative_index("r1_local", "(P - U)", (P - U));
        context__.validate_dims("parameter initialization", "r1_local", "vector_d", context__.to_vec((P - U)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> r1_local((P - U));
        size_t r1_local_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < r1_local_j_1_max__; ++j_1__) {
            r1_local(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, r1_local);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable r1_local: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 99;
        if (!(context__.contains_r("r2_local")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable r2_local missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("r2_local");
        pos__ = 0U;
        validate_non_negative_index("r2_local", "(P - U)", (P - U));
        context__.validate_dims("parameter initialization", "r2_local", "vector_d", context__.to_vec((P - U)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> r2_local((P - U));
        size_t r2_local_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < r2_local_j_1_max__; ++j_1__) {
            r2_local(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, r2_local);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable r2_local: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 100;
        if (!(context__.contains_r("c2")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable c2 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("c2");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "c2", "double", context__.to_vec());
        double c2(0);
        c2 = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, c2);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable c2: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 89;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_u;
            (void) beta_u;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_u = in__.vector_constrain(U, lp__);
            else
                beta_u = in__.vector_constrain(U);
            current_statement_begin__ = 92;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 95;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> z;
            (void) z;  // dummy to suppress unused var warning
            if (jacobian__)
                z = in__.vector_constrain((P - U), lp__);
            else
                z = in__.vector_constrain((P - U));
            current_statement_begin__ = 96;
            local_scalar_t__ r1_global;
            (void) r1_global;  // dummy to suppress unused var warning
            if (jacobian__)
                r1_global = in__.scalar_lb_constrain(0, lp__);
            else
                r1_global = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 97;
            local_scalar_t__ r2_global;
            (void) r2_global;  // dummy to suppress unused var warning
            if (jacobian__)
                r2_global = in__.scalar_lb_constrain(0, lp__);
            else
                r2_global = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 98;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> r1_local;
            (void) r1_local;  // dummy to suppress unused var warning
            if (jacobian__)
                r1_local = in__.vector_lb_constrain(0, (P - U), lp__);
            else
                r1_local = in__.vector_lb_constrain(0, (P - U));
            current_statement_begin__ = 99;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> r2_local;
            (void) r2_local;  // dummy to suppress unused var warning
            if (jacobian__)
                r2_local = in__.vector_lb_constrain(0, (P - U), lp__);
            else
                r2_local = in__.vector_lb_constrain(0, (P - U));
            current_statement_begin__ = 100;
            local_scalar_t__ c2;
            (void) c2;  // dummy to suppress unused var warning
            if (jacobian__)
                c2 = in__.scalar_lb_constrain(0, lp__);
            else
                c2 = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 106;
            validate_non_negative_index("beta_p", "(P - U)", (P - U));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_p((P - U));
            stan::math::initialize(beta_p, DUMMY_VAR__);
            stan::math::fill(beta_p, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 108;
            if (as_bool(regularized)) {
                current_statement_begin__ = 109;
                stan::math::assign(beta_p, reg_hs(z, r1_local, r2_local, r1_global, r2_global, (global_scale * sigma), (slab_scale * c2), pstream__));
            } else {
                current_statement_begin__ = 112;
                stan::math::assign(beta_p, hs(z, r1_local, r2_local, r1_global, r2_global, pstream__));
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 106;
            size_t beta_p_j_1_max__ = (P - U);
            for (size_t j_1__ = 0; j_1__ < beta_p_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta_p(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta_p" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta_p: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            {
            current_statement_begin__ = 118;
            validate_non_negative_index("mu", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(N);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            stan::math::assign(mu,add(multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, U), stan::model::nil_index_list())), "X"), beta_u), multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max((U + 1), P), stan::model::nil_index_list())), "X"), beta_p)));
            current_statement_begin__ = 121;
            lp_accum__.add(std_normal_log<propto__>(z));
            current_statement_begin__ = 122;
            lp_accum__.add(std_normal_log<propto__>(r1_local));
            current_statement_begin__ = 123;
            lp_accum__.add(inv_gamma_log<propto__>(r2_local, (0.5 * nu), (0.5 * nu)));
            current_statement_begin__ = 124;
            lp_accum__.add(std_normal_log<propto__>(r1_global));
            current_statement_begin__ = 125;
            lp_accum__.add(inv_gamma_log<propto__>(r2_global, (0.5 * global_df), (0.5 * global_df)));
            current_statement_begin__ = 128;
            lp_accum__.add(inv_gamma_log<propto__>(c2, (0.5 * slab_df), (0.5 * slab_df)));
            current_statement_begin__ = 131;
            lp_accum__.add(normal_log<propto__>(beta_u, 0, scale_u));
            current_statement_begin__ = 134;
            lp_accum__.add(inv_gamma_log<propto__>(sigma, 1, 1));
            current_statement_begin__ = 137;
            lp_accum__.add(normal_log<propto__>(y, mu, sigma));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta_u");
        names__.push_back("sigma");
        names__.push_back("z");
        names__.push_back("r1_global");
        names__.push_back("r2_global");
        names__.push_back("r1_local");
        names__.push_back("r2_local");
        names__.push_back("c2");
        names__.push_back("beta_p");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(U);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((P - U));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((P - U));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((P - U));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((P - U));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_hs_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_u = in__.vector_constrain(U);
        size_t beta_u_j_1_max__ = U;
        for (size_t j_1__ = 0; j_1__ < beta_u_j_1_max__; ++j_1__) {
            vars__.push_back(beta_u(j_1__));
        }
        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);
        Eigen::Matrix<double, Eigen::Dynamic, 1> z = in__.vector_constrain((P - U));
        size_t z_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            vars__.push_back(z(j_1__));
        }
        double r1_global = in__.scalar_lb_constrain(0);
        vars__.push_back(r1_global);
        double r2_global = in__.scalar_lb_constrain(0);
        vars__.push_back(r2_global);
        Eigen::Matrix<double, Eigen::Dynamic, 1> r1_local = in__.vector_lb_constrain(0, (P - U));
        size_t r1_local_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < r1_local_j_1_max__; ++j_1__) {
            vars__.push_back(r1_local(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> r2_local = in__.vector_lb_constrain(0, (P - U));
        size_t r2_local_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < r2_local_j_1_max__; ++j_1__) {
            vars__.push_back(r2_local(j_1__));
        }
        double c2 = in__.scalar_lb_constrain(0);
        vars__.push_back(c2);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 106;
            validate_non_negative_index("beta_p", "(P - U)", (P - U));
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta_p((P - U));
            stan::math::initialize(beta_p, DUMMY_VAR__);
            stan::math::fill(beta_p, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 108;
            if (as_bool(regularized)) {
                current_statement_begin__ = 109;
                stan::math::assign(beta_p, reg_hs(z, r1_local, r2_local, r1_global, r2_global, (global_scale * sigma), (slab_scale * c2), pstream__));
            } else {
                current_statement_begin__ = 112;
                stan::math::assign(beta_p, hs(z, r1_local, r2_local, r1_global, r2_global, pstream__));
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t beta_p_j_1_max__ = (P - U);
                for (size_t j_1__ = 0; j_1__ < beta_p_j_1_max__; ++j_1__) {
                    vars__.push_back(beta_p(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    static std::string model_name() {
        return "model_hs";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_u_j_1_max__ = U;
        for (size_t j_1__ = 0; j_1__ < beta_u_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_u" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t z_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "r1_global";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "r2_global";
        param_names__.push_back(param_name_stream__.str());
        size_t r1_local_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < r1_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r1_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t r2_local_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < r2_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r2_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "c2";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_p_j_1_max__ = (P - U);
            for (size_t j_1__ = 0; j_1__ < beta_p_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_p" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_u_j_1_max__ = U;
        for (size_t j_1__ = 0; j_1__ < beta_u_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_u" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t z_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < z_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "z" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "r1_global";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "r2_global";
        param_names__.push_back(param_name_stream__.str());
        size_t r1_local_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < r1_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r1_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t r2_local_j_1_max__ = (P - U);
        for (size_t j_1__ = 0; j_1__ < r2_local_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "r2_local" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "c2";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t beta_p_j_1_max__ = (P - U);
            for (size_t j_1__ = 0; j_1__ < beta_p_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_p" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_hs_namespace::model_hs stan_model;
#endif
