% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimation.R
\name{posterior_interval.hsstan}
\alias{posterior_interval.hsstan}
\alias{posterior_interval}
\title{Posterior uncertainty intervals}
\usage{
\method{posterior_interval}{hsstan}(object, pars = NULL, prob = 0.95,
  ...)
}
\arguments{
\item{object}{An object of class \code{hsstan}.}

\item{pars}{Names of parameters for which posterior intervals should be
returned, which can be specified as regular expressions. If \code{NULL}
(default) then this refers to the set of predictors used in the model.}

\item{prob}{A value between 0 and 1 indicating the desired probability
to be covered by the uncertainty intervals (0.95, by default).}

\item{...}{Currently ignored.}
}
\value{
A matrix with lower and upper interval bounds as columns and as many rows
as selected parameters.
}
\description{
Compute posterior uncertainty intervals for \code{hsstan} objects.
}
\examples{
\dontshow{utils::example("hsstan", echo=FALSE)}
# continued from ?hsstan
posterior_interval(hs.biom)

}
