% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{sign_coherence}
\alias{sign_coherence}
\title{Sign Coherence Constraint}
\usage{
sign_coherence(vars, big_m = 100, eps = 1e-06)
}
\arguments{
\item{vars}{a character vector giving the names of the covariates the
constraint should be applied to.}

\item{big_m}{a double giving the big-M parameter.}

\item{eps}{a double giving the epsilon used to ensure that the constraint holds.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Constraint which ensures that the coefficients of the specified covariates have
a coherent sign.
}
\examples{
dat <- rhglm(100, c(1, -2, 3, 4, 5, 6))
constraints <- sign_coherence(c("x1", "x3"))
hglm(y ~ ., constraints = constraints, data = dat)
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_equal}()},
\code{\link{group_inout}()},
\code{\link{group_sparsity}()},
\code{\link{include}()},
\code{\link{k_max}()},
\code{\link{linear}()},
\code{\link{lower}()},
\code{\link{pairwise_sign_coherence}()},
\code{\link{rho_max}()},
\code{\link{upper}()}
}
\concept{Constraint-Constructors}
