% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elapsed.R
\name{tmr_elapsed}
\alias{tmr_elapsed}
\title{Elapsed Time hms Timer}
\usage{
tmr_elapsed(x)
}
\arguments{
\item{x}{A \code{\link[=hms_timer]{hms_timer()}}.}
}
\value{
A \code{\link[=hms_timer]{hms_timer()}} of the elapsed time.
}
\description{
Returns the elapsed time for a \code{\link[=hms_timer]{hms_timer()}} as a \code{\link[=hms_timer]{hms_timer()}}.
}
\details{
The elapsed time is the value of the scalar plus the difference
between the current system time and the system time when the timer was started.

If the original \code{\link[=hms_timer]{hms_timer()}} was running then the new \code{\link[=hms_timer]{hms_timer()}}
is assigned an attribute named start of the current system time.
}
\examples{
tmr <- tmr_start(tmr_timer())
print(tmr_elapsed(tmr))
Sys.sleep(0.01)
print(tmr_elapsed(tmr))
tmr <- tmr_stop(tmr)
print(tmr_elapsed(tmr))
Sys.sleep(0.01)
print(tmr_elapsed(tmr))
}
\seealso{
Other start_stop: 
\code{\link{tmr_is_started}()},
\code{\link{tmr_is_stopped}()},
\code{\link{tmr_print}()},
\code{\link{tmr_reset}()},
\code{\link{tmr_start}()},
\code{\link{tmr_stop}()},
\code{\link{tmr_timer}()}
}
\concept{start_stop}
