% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.fhmm}
\alias{summary.fhmm}
\title{Summarizing functional Hidden Markov Models}
\usage{
\method{summary}{fhmm}(object, ...)
}
\arguments{
\item{object}{an object of class "\code{fhmm}", a result of a call to \code{fitBM_fhmm}}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
The function "\code{summary_fhmm}" returns a list of summary statistics for a hidden markov model with functional response obtained through the Baum-Welch algorithm.
}
\description{
\code{summary} method for class "\code{fhmm}".
}
\examples{
\donttest{
data(simulatedFD)
n <- 20
n_tot <- 2000
bt <- seq(1,n_tot,by=n)
FD <- simulatedFD
hmm <- set_fhmm(FD, nStates = 3, bT=bt)

bw <- fitBM_fhmm(hmm)
summary(bw)}
}
\references{
Martino A., Guatteri, G. and Paganoni A. M., Hidden Markov Models for multivariate functional data, MOX Report 21/2019, 2019
}
\seealso{
\code{\link{fitBM_fhmm}}
}
