% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_cycle.R
\name{imputationcycle}
\alias{imputationcycle}
\title{Cycling}
\usage{
imputationcycle(data_before, original_data, NA_locator, fe,
  interaction_names, list_of_types, nitt, burnin, thin, pvalue = 0.2, mn,
  k = Inf, spike = NULL, rounding_degrees = NULL,
  rounding_covariates)
}
\arguments{
\item{data_before}{The n x p data.frame with the variables to impute. It was prepared for imputation in the \code{wrapper} function.
The preparation includes the adding of intercept variables or interactions or the joining of small clusters.}

\item{original_data}{The original data.frame the user passed to \code{hmi}.}

\item{NA_locator}{A n x p matrix localizing the missing values in the original
dataset. The elements are TRUE if the original data are missing and FALSE if the
are observed.}

\item{fe}{A list with the decomposed elements of the \code{model_formula}.}

\item{interaction_names}{A list with the names of the variables
that have been generated as interaction variables}

\item{list_of_types}{a list where each list element has the name of a variable
in the data.frame. The elements have to contain a single character denoting the type of the variable.
See \code{get_type} for details about the variable types.
With the function \code{list_of_types_maker}, the user can get the framework for this object.
In most scenarios this is should not be necessary.
One example where it might be necessary is when only two observations
of a continuous variable are left - because in this case \code{get_type}
interpret is variable to be binary. Wrong is it in no case.}

\item{nitt}{An integer defining number of MCMC iterations (see \code{MCMCglmm}).}

\item{burnin}{burnin A numeric value between 0 and 1 for the desired percentage of
Gibbs samples that shall be regarded as burnin.}

\item{thin}{An integer to set the thinning interval range. If thin = 1,
every iteration of the Gibbs-sampling chain will be kept. For highly autocorrelated
chains, that are only examined by few iterations (say less than 1000),
the \code{geweke.diag} might fail to detect convergence. In such cases it is
essential to look a chain free from autocorrelation.}

\item{pvalue}{A numeric between 0 and 1 denoting the threshold of p-values a variable in the imputation
model should not exceed. If they do, they are excluded from the imputation model.}

\item{mn}{An integer defining the minimum number of individuals per cluster.}

\item{k}{An integer defining the allowed maximum of levels in a factor covariate.}

\item{spike}{A numeric value saying which value in the semi-continuous data might be the spike.
Or a list with with such values and names identical to the variables with spikes
(see \code{list_of_spikes_maker} for details).}

\item{rounding_degrees}{A numeric vector with the presumed rounding degrees. Or a list with rounding degrees,
where each list element has the name of a rounded continuous variable. Such a list can be generated
using \code{list_of_rounding_degrees_maker(data)}.}

\item{rounding_covariates}{A list for each rounded continuous variable with a character vector
containing the covariate names from the original rounding formula.
The transformation takes place in the wrapper function.}
}
\value{
A data.frame where the values, that have a missing value in the original
dataset, are imputed.
}
\description{
Function to do one imputation cycle on the given data. The function cycles through
every variable sequentially imputing the values, that are NA in the original data set
in that current variable. The function determines the type of the variable
and calls the suitable imputation function.
}
