% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2017-12-28.R
\name{get_type}
\alias{get_type}
\title{Get the type of variables.}
\usage{
get_type(variable, rounding_degrees = c(1, 10, 100, 1000))
}
\arguments{
\item{variable}{A variable (vector) from your data set.}

\item{rounding_degrees}{A numeric vector with the presumed rounding degrees.}
}
\value{
A character denoting the type of \code{variable}.
}
\description{
Function checks whether a variable is: ...
\itemize{
 \item continuous (numeric values),
 \item semicontinuous (numeric values with more than 5\% of them are 0),
 \item rounded continuous (if continuous values are rounded to the closest multiple of 5, 10, 50, 100, 500 or 1000.
 We see this to be the case if more than 50\% of the observations are divisible by 5)
 \item count data (if all values are integers).
 \item an intercept (the same value for all observations),
 \item binary (two different values - like 0s and 1s or "m" and "f"),
 \item categorical (the variable is a factor or has more than 3 different values)
 \item ordered categorical (the categorical variable is ordered.)
}
}
\examples{
get_type(iris$Sepal.Length); get_type(iris$Species)
}
