% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simrRUM}
\alias{simrRUM}
\title{Simulate rRUM model responses (entire cube)}
\usage{
simrRUM(alphas, r_stars_mat, pi_stars, Q_matrix, Test_order, Test_versions)
}
\arguments{
\item{alphas}{An N-by-K-by-L \code{array} of attribute patterns of all persons across L time points}

\item{r_stars_mat}{A J-by-K \code{cube} of item penalty parameters for missing skills across all item blocks}

\item{pi_stars}{A Jt-by-L \code{matrix} of item correct response probability with all requisite skills across blocks}

\item{Q_matrix}{A J-by-K of Q-matrix}

\item{Test_order}{A N_versions-by-L \code{matrix} indicating which block of items were administered to examinees with specific test version.}

\item{Test_versions}{A length N \code{vector} of the test version of each examinee}
}
\value{
An \code{array} of rRUM item responses of examinees across all time points
}
\description{
Simulate a cube of rRUM responses for all persons on items across all time points
}
\examples{
N = length(Test_versions)
J = nrow(Q_matrix)
K = ncol(Q_matrix)
L = nrow(Test_order)
Jt = J/L
Smats <- matrix(runif(J*K,.1,.3),c(J,K))
Gmats <- matrix(runif(J*K,.1,.3),c(J,K))
r_stars <- Gmats / (1-Smats)
pi_stars <- matrix(apply((1-Smats)^Q_matrix, 1, prod), nrow=Jt, ncol=L, byrow=L)
Test_versions_sim <- sample(1:5,N,replace = L)
tau <- numeric(K)
  for(k in 1:K){
    tau[k] <- runif(1,.2,.6)
  }
  R = matrix(0,K,K)
# Initial alphas
p_mastery <- c(.5,.5,.4,.4)
Alphas_0 <- matrix(0,N,K)
for(i in 1:N){
  for(k in 1:K){
    prereqs <- which(R[k,]==1)
    if(length(prereqs)==0){
      Alphas_0[i,k] <- rbinom(1,1,p_mastery[k])
    }
    if(length(prereqs)>0){
      Alphas_0[i,k] <- prod(Alphas_0[i,prereqs])*rbinom(1,1,p_mastery)
    }
  }
}
Alphas <- simulate_alphas_indept(tau,Alphas_0,L,R) 
Y_sim = simrRUM(Alphas,r_stars,pi_stars,Q_matrix,Test_order,Test_versions_sim)
}
