% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_airports}
\alias{make_airports}
\title{Make or load airport data}
\usage{
make_airports(ap = NA, crs = 4326, warn = TRUE)
}
\arguments{
\item{ap}{Dataframe containing the minimum fields, or NA (default)}

\item{crs}{Coordinate reference system for the coded lat-longs.
Default 4326.}

\item{warn}{warn if default set is used (default = TRUE)}
}
\value{
Dataframe with, in addition, a geocoded lat-long.
}
\description{
\code{make_airports} ensures a minimum set of variables describing airports
}
\details{
This function provides a test set of airports if necessary from
\code{airportr::airports} and geocodes the lat-long of this or the dataset
provide as \code{ap}.

This minimal set needs to have the following fields:

\itemize{
  \item \code{APICAO}: the 4-letter ICAO code for the airport (though there is no
  validity check applied, so 'TEST', or 'ZZZZ' could be used, for example)
  \item \code{lat, long}: latitude and longitude in decimal degrees
}
}
\examples{
# do minimal version
airports <- make_airports()

# on-the-fly example
airports <- data.frame(APICAO = "TEST", lat = 10, long = 10, stringsAsFactors = FALSE)
airports <- make_airports(airports)

\dontrun{
# example for your own data
airports <- utils::read.csv("data/airports.csv", stringsAsFactors = FALSE)
airports <- make_airports(airports)
}

}
