% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_test.R
\name{div_test}
\alias{div_test}
\title{Diversity test}
\usage{
div_test(countable, qvalue, hierarchy, tree, posthoc)
}
\arguments{
\item{countable}{A matrix indicating the relative abundances of multiple samples. Columns should be samples and rows OTUs.}

\item{qvalue}{A positive integer or decimal number (>=0), usually between 0 and 3.}

\item{hierarchy}{A two-column matrix indicating the relation between samples (first column) and groups (second column).}

\item{tree}{A phylogenetic tree of class 'phylo'. The tip labels must match the row names in the OTU table. Use the function match_data() if the OTU names do not match.}

\item{posthoc}{Whether to run post hoc pairwise analyses or not. If TRUE, an ANOVA will be complemented with a Tukey test and a Kruskal-Wallis test will be complemented with a Dunn test.}
}
\value{
A statistical test output.
}
\description{
Diversity comparison test between groups of samples. The function automatically assesses whether the data meets the properties for parametric statistics and performs the appropriate test accordingly: Students' T, ANOVA, Wilcoxon or Kruskal-Wallis. If the posthoc argument is set as TRUE, multiple group comparisons are complemented with post hoc pairwise tests, either Tukey test (parametric) or Dunn test with Benjamini-Hochberg correction (non-parametric).
}
\details{
Diversity test
}
\examples{
data(bat.diet.otutable)
data(bat.diet.tree)
data(bat.diet.hierarchy)
div_test(bat.diet.otutable,qvalue=0,hierarchy=bat.diet.hierarchy)
div_test(bat.diet.otutable,qvalue=1,hierarchy=bat.diet.hierarchy,tree=bat.diet.tree)
div_test(bat.diet.otutable,2,bat.diet.hierarchy,bat.diet.tree)
div_test(bat.diet.otutable,qvalue=1,hierarchy=bat.diet.hierarchy,posthoc=TRUE)
}
\references{
Alberdi, A., Gilbert, M.T.P. (2019). A guide to the application of Hill numbers to DNA-based diversity analyses. Molecular Ecology Resources, 19, 804-817.\cr\cr
Chao, A., Chiu, C.H., & Jost, L. (2014). Unifying species diversity, phylogenetic diversity, functional diversity, and related similarity and differentiation measures through hill numbers. Annual Review of Ecology Evolution and Systematics, 45, 297-324.
}
\seealso{
\code{\link{hill_div}}, \code{\link{div_part}}
}
\author{
Antton Alberdi, \email{anttonalberdi@gmail.com}
}
\keyword{comparison}
\keyword{hill}
\keyword{numbers}
