% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jump_tests.R
\name{rankJumpTest}
\alias{rankJumpTest}
\title{Rank jump test}
\usage{
rankJumpTest(
  marketPrice,
  stockPrices,
  alpha = c(5, 3),
  coarseFreq = 10,
  localWindow = 30,
  rank = 1,
  BoxCox = 1,
  nBoot = 1000,
  dontTestAtBoundaries = TRUE,
  on = "minutes",
  k = 5,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = "GMT"
)
}
\arguments{
\item{marketPrice}{data.table or xts containing the market prices in levels}

\item{stockPrices}{list containing the individual stock prices in either data.table or xts format. The format should be the the same as \code{marketPrice}}

\item{alpha}{signicance level (in standard deviations) to use for the jump detections. Default is \code{c(5,3)} for 5 and 3 in the market and stocks respectively.}

\item{coarseFreq}{numeric denoting the coarse sampling frequency. Default is \code{10}}

\item{localWindow}{numeric denoting the local window for the bootstrap algorithm. Default is \code{30}}

\item{rank}{rank of the jump matrix under the null hypothesis. Default is \code{1}}

\item{BoxCox}{numeric of exponents for the Box-Cox transformation, default is \code{1}}

\item{nBoot}{numeric denoting how many replications to be used for the bootstrap algorithm. Default is \code{1000}}

\item{dontTestAtBoundaries}{logical determining whether to exclude data across different days. Default is \code{TRUE}}

\item{on}{string indicating the time scale in which \code{k} is expressed.
Possible values are: \code{"secs", "seconds", "mins", "minutes", "hours"}.}

\item{k}{positive integer, indicating the number of periods to aggregate
over. E.g. to aggregate an \code{xts} object to the 5 minute frequency, set
\code{k = 5} and \code{on = "minutes"}.}

\item{marketOpen}{the market opening time. This should be in the time zone
specified by \code{tz}. By default, \code{marketOpen = "09:30:00"}.}

\item{marketClose}{the market closing time. This should be in the time zone
specified by \code{tz}. By default, \code{marketClose = "16:00:00"}.}

\item{tz}{string specifying the time zone to which the times in \code{data}
and/or \code{marketOpen}/ \code{marketClose} belong. Default = \code{"GMT"}.
This parameter will also help determine the testing times as the test is done on non-overlapping pre-averaged returns.}
}
\value{
A list containing "criticalValues" which are the bootstrapped critcal values, "testStatistic" the test statistic of the jump test, "dimensions" which are the dimensions of the jump matrix
 "marketJumpDetections" the jumps detected in the market prices, "stockJumpDetections" the co-jumps detected in the individual stock prices, and "jumpIndices" which are the indices of the detected jumps.
}
\description{
Rank jump test
}
\examples{
\dontrun{
#Rank jump test using simulated sample data that includes jumps
## pretend that the marketPrice is the first asset in the data:
marketPrice <- sample5MinPricesJumps[,1] 
## construct stockPrice as a list:
stockPrice <- list() 
for (i in 1:(ncol(sample5MinPricesJumps)-1)) {
  stockPrice[[i]] <- sample5MinPricesJumps[,i+1]
}
## This can take a long time due to the bootstrapping
rankTest <- rankJumpTest(marketPrice, stockPrice, coarseFreq = 10, k = 1, alpha = c(5,3), 
                         tz = "GMT", marketOpen = "09:30:00", marketClose = "16:00:00")
# Plot the detected stock jump detections
plot(rankTest$stockJumpDetections)
}

}
