\name{exchangeHoursOnly}
\Rdversion{1.1}
\alias{exchangeHoursOnly}
\title{
Extract data from an xts object for the Exchange Hours Only
}
\description{
The function returns data within exchange trading hours
"daybegin" and "dayend". By default, daybegin and dayend
are set to "09:30:00" and "16:00:00" respectively (see Brownlees and Gallo (2006) for more information on good choices for these arguments).
}

\usage{
exchangeHoursOnly(data, daybegin = "09:30:00", dayend = "16:00:00")
}

\arguments{
  \item{data}{ an xts object containing the time series data. }
  \item{daybegin}{ character in the format of "HH:MM:SS",
specifying the starting hour, minute and second of an exhange
trading day.}
  \item{dayend}{ character in the format of "HH:MM:SS",
specifying the closing hour, minute and second of an exhange
trading day.}
}

\value{
xts object
}
\references{
Brownlees, C.T. and Gallo, G.M. (2006). 
Financial econometric analysis at ultra-high frequency: Data handling concerns.
 Computational Statistics & Data Analysis, 51, pages 2232-2245.
}

\author{ Jonathan Cornelissen and Kris Boudt}

\keyword{ cleaning }
