% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc.R
\name{hc_plotOptions}
\alias{hc_plotOptions}
\title{Setting plot options to highchart objects}
\usage{
hc_plotOptions(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments are defined in \url{http://api.highcharts.com/highcharts#plotOptions}.}
}
\description{
The plotOptions is a wrapper object for config objects for each series type. The configuration
objects for each series can also be overridden for each series item as given in the series array.
}
\details{
Configuration options for the series are given in three levels. Options for all series in a
chart are given with the \code{hc_plotOptions} function. Then options for all series of a specific
type are given in the plotOptions of that type, for example  \code{hc_plotOptions(line = list(...))}.
Next, options for one single series are given in the series array.
}
\examples{

data(citytemp)

hc <- highchart() \%>\% 
  hc_plotOptions(line = list(color = "blue",
                             marker = list(
                               fillColor = "white",
                               lineWidth = 2,
                               lineColor = NULL
                               )
  )) \%>\%  
  hc_add_series(name = "Tokyo", data = citytemp$tokyo) \%>\% 
  hc_add_series(name = "London", data = citytemp$london,
               marker = list(fillColor = "black"))


hc

# override the `blue` option with the explicit parameter
hc \%>\% 
  hc_add_series(name = "London",
               data = citytemp$new_york,
               color = "red")

}
