% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc-hc_add_series-deprecated.R
\name{hc_add_series_flags}
\alias{hc_add_series_flags}
\title{Shortcut for add flags to highstock chart}
\usage{
hc_add_series_flags(hc, dates, title = LETTERS[seq(length(dates))],
  text = title, id = NULL, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{dates}{Date vector.}

\item{title}{A character vector with titles.}

\item{text}{A character vector with the description.}

\item{id}{The name of the series to add the flags. A previous series
must be added with this \code{id}.}

\item{...}{Additional shared arguments for the \emph{flags} data series
(\url{http://api.highcharts.com/highstock#plotOptions.flags})}
}
\description{
This function helps to add flags highstock charts created from \code{xts} objects.
}
\examples{


\dontrun{

library("quantmod")

usdjpy <- getSymbols("USD/JPY", src="oanda", auto.assign = FALSE)

dates <- as.Date(c("2015-05-08", "2015-09-12"), format = "\%Y-\%m-\%d")
highchart(type = "stock") \%>\% 
  hc_add_series_xts(usdjpy, id = "usdjpy") \%>\% 
  hc_add_series_flags(dates,
                      title = c("E1", "E2"), 
                      text = c("This is event 1", "This is the event 2"),
                      id = "usdjpy") 
}
                      
}
