% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc-hc_add_series-deprecated.R
\name{hc_add_series_treemap}
\alias{hc_add_series_treemap}
\title{Shorcut for create treemaps}
\usage{
hc_add_series_treemap(hc, tm, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{tm}{A \code{treemap} object from the treemap package.}

\item{...}{Aditional shared arguments for the data series
(\url{http://api.highcharts.com/highcharts#series}).}
}
\description{
This function helps to create higcharts treemaps from \code{treemap} objects
from the package \code{treemap}.
}
\examples{
 
\dontrun{

library("treemap")
library("viridis")

data(GNI2014)
head(GNI2014)

tm <- treemap(GNI2014, index = c("continent", "iso3"),
              vSize = "population", vColor = "GNI",
              type = "comp", palette = rev(viridis(6)),
              draw = FALSE)

highchart(height = 800) \%>\% 
  hc_add_series_treemap(tm, allowDrillToNode = TRUE,
                       layoutAlgorithm = "squarified",
                       name = "tmdata") \%>\% 
   hc_title(text = "Gross National Income World Data") \%>\% 
   hc_tooltip(pointFormat = "<b>{point.name}</b>:<br>
                             Pop: {point.value:,.0f}<br>
                             GNI: {point.valuecolor:,.0f}")

}

}

