% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{hc_credits}
\alias{hc_credits}
\title{Adding credits options to highchart objects}
\usage{
hc_credits(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{http://api.highcharts.com/highcharts#credits}.}
}
\description{
\code{highcarter} by default don't put credits in the chart.
You can add credits using these options.
}
\examples{

require("dplyr")

data("citytemp")

highchart() \%>\% 
  hc_xAxis(categories = citytemp$month) \%>\% 
  hc_add_serie(name = "Tokyo", data = citytemp$tokyo, type = "bar") \%>\% 
  hc_credits(enabled = TRUE, text = "htmlwidgets.org",
             href = "http://www.htmlwidgets.org/")
             
}

