% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial-cluster.R
\name{initial_cluster}
\alias{initial_cluster}
\title{initial clustering of the data set}
\usage{
initial_cluster(
  train,
  nstate,
  nmix,
  ltr = FALSE,
  final.absorb = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{train}{the train data set of class \code{"hhsmmdata"}}

\item{nstate}{number of states}

\item{nmix}{number of mixture components which is of one of the following forms:
\itemize{
\item a vector of positive (non-zero) integers of length \code{nstate}
\item a positive (non-zero) integer
\item the text \code{"auto"}: the number of mixture components will be determined
automatically based on the within cluster sum of squares
}}

\item{ltr}{logical. if TRUE a left to right hidden hybrid Markov/semi-Markov model is assumed}

\item{final.absorb}{logical. if TRUE the final state of the sequence is assumed to be the absorbance state}

\item{verbose}{logical. if TRUE the outputs will be printed}
}
\value{
a list of class \code{"hhsmm.clust"} containing the following items:
\itemize{
\item \code{clust.X}{ a list of clustered observations for each sequence and state}
\item \code{mix.clus}{ a list of the clusters for the mixtures for each state}
\item \code{state.clus}{ the exact state clusters of each observation (available if \code{ltr}=FALSE)}
\item \code{nmix}{ the number of mixture components (a vector of positive (non-zero) integers of length \code{nstate})}
\item \code{ltr}{ logical. if TRUE a left to right hidden hybrid Markov/semi-Markov model is assumed}
\item \code{final.absorb}{ logical. if TRUE the final state of the sequence is assumed to be the absorbance state}
}
}
\description{
Provides an initial clustering for a data of class \code{"hhsmmdata"} which
determines the initial states and mixture components (if necessary)
to be used for initial parameter and model estimation
}
\details{
In reliability applications, the hhsmm models are often left-to-right
and the modeling aims to predict the future states. In such cases, the
\code{ltr}=TRUE and \code{final.absorb}=TRUE should be set.
}
\examples{
J <- 3
initial <- c(1,0,0)
semi <- c(FALSE,TRUE,FALSE)
P <- matrix(c(0.8, 0.1, 0.1, 0.5, 0, 0.5, 0.1, 0.2, 0.7), nrow = J, byrow=TRUE)
par <- list(mu = list(list(7,8),list(10,9,11),list(12,14)),
sigma = list(list(3.8,4.9),list(4.3,4.2,5.4),list(4.5,6.1)),
mix.p = list(c(0.3,0.7),c(0.2,0.3,0.5),c(0.5,0.5)))
sojourn <- list(shape = c(0,3,0), scale = c(0,10,0), type = "gamma")
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixmvnorm, sojourn = sojourn, semi = semi)
train <- simulate(model, nsim = c(10,8,8,18), seed = 1234, remission = rmixmvnorm)
test <-  simulate(model, nsim = c(7,3,3,8), seed = 1234, remission = rmixmvnorm)
clus = initial_cluster(train,nstate=3,nmix=c(2,2,2),ltr=FALSE,
final.absorb=FALSE,verbose=TRUE)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat,  \email{aftbayat@gmail.com}
}
