% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_base_functions.R
\name{mni.control}
\alias{mni.control}
\title{mni.control}
\usage{
mni.control(
  mni_trials = 1,
  mni_n_folds = 10,
  mni_n_trees = 1,
  mni_size = 0.01,
  mni_start = 0.05,
  mni_numvals = 50,
  ...
)
}
\arguments{
\item{mni_trials}{The number of times the process is repeated i.e. how many times the
n-fold cross-validation process is repeated. The resulting value of min_node_impurity
is the mean of mni_trials trials. The default value is 1.}

\item{mni_n_folds}{The number of folds to use when evaluating values of min_node_impurity.
Any integer value in the range 1 to the number of observations in the training dataset is
accepted. The default value is 10.}

\item{mni_n_trees}{The number of trees to use when evaluating values of min_node_impurity.
At the time of writing the only allowable value is 1. The default value is 1.}

\item{mni_size}{After a value of min_node_impurity is tried, the next value is calculated
by adding mni_size to the previous value. A value in the range 0.001 to 0.10 is accepted.
The default value is 0.01.}

\item{mni_start}{The first value of min_node_impurity to be evaluated. A value in the range
0.001 to 1.0 is accepted. The default value is 0.05.}

\item{mni_numvals}{The number of min_node_impurity values to try while attempting to find
the optimum. Any integer value in the range 1 to 1000 is accepted. The default value is 50.}

\item{...}{parameter catch all.}
}
\value{
Returns a list of all validated parameters.
}
\description{
This internal function is used to validate the parameters specified on the control
parameter.
}
\details{
The following parameters are supported:
}
