% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableSelectionNew.R
\name{HCPM}
\alias{HCPM}
\title{Heterogeneous correlation and p-value matrices}
\usage{
HCPM(data = NULL)
}
\arguments{
\item{data}{A data frame. Values of type 'numeric' or 'integer' are treated as numerical.}
}
\value{
A list with with elements:
   \item{cor_mat}{An \eqn{p} by \eqn{p} heterogeneous correlation matrix}
   \item{p_value}{An \eqn{p} by \eqn{p} heterogeneous p-values matrix}
}
\description{
Extends the traditional correlation matrix (between numerical data) to also
include binary and ordinal categorical data and computes the p-values for the tests of uncorrelation.
}
\references{
Tortora C., Madhvani S., Punzo A.  (2025). Designing unsupervised mixed-type
feature selection techniques using the
heterogeneous correlation matrix. International Statistical Review.
https://doi.org/10.1111/insr.70016
}
\examples{
 
data(ESI)
data=ESI[,-c(1,3,4,6,9)]##removing categorical features
HCPM(data)

}
