% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMSE.R
\name{allocate_mult}
\alias{allocate_mult}
\title{Allocation of replicates on existing designs}
\usage{
allocate_mult(model, N, Wijs = NULL, use.Ki = FALSE)
}
\arguments{
\item{model}{\code{hetGP} model}

\item{N}{total budget of replication to allocate}

\item{Wijs}{optional previously computed matrix of \code{Wijs}, see \code{\link[hetGP]{Wij}}}

\item{use.Ki}{should \code{Ki} from \code{model} be used? 
Using the inverse of C (covariance matrix only, without noise, using \code{\link[MASS]{ginv}}) is also possible}
}
\value{
vector with approximated best number of replicates per design
}
\description{
Allocation of replicates on existing design locations, based on (29) from (Ankenman et al, 2010)
}
\examples{
##------------------------------------------------------------
## Example: Heteroskedastic GP modeling on the motorcycle data
##------------------------------------------------------------
set.seed(32)

## motorcycle data
library(MASS)
X <- matrix(mcycle$times, ncol = 1)
Z <- mcycle$accel
nvar <- 1

data_m <- find_reps(X, Z, rescale = TRUE)

plot(rep(data_m$X0, data_m$mult), data_m$Z, ylim = c(-160, 90),
     ylab = 'acceleration', xlab = "time")


## Model fitting
model <- mleHetGP(X = list(X0 = data_m$X0, Z0 = data_m$Z0, mult = data_m$mult),
                  Z = Z, lower = rep(0.1, nvar), upper = rep(50, nvar),
                  covtype = "Matern5_2")
## Compute best allocation                  
A <- allocate_mult(model, N = 1000)

plot(X, Z, ylim = c(-160, 90), ylab = 'acceleration', xlab = "time")

## Create a prediction grid and obtain predictions
xgrid <- matrix(seq(0, 60, length.out = 301), ncol = 1) 
predictions <- predict(x = xgrid, object =  model)
par(new = TRUE)
plot(NA,NA, xlim = c(0,1), ylim = c(0,max(A)), axes = FALSE, ylab = "", xlab = "")
segments(x0 = model$X0, x1 = model$X0, 
y0 = rep(0, nrow(model$X)), y1 = A, col = 'grey')
axis(side = 4)
mtext(side = 4, line = 2, expression(a[i]), cex = 0.8)       
}
\references{
B. Ankenman, B. Nelson, J. Staum (2010), Stochastic kriging for simulation metamodeling, Operations research, pp. 371--382, 58
}
