% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{merge_pair}
\alias{merge_pair}
\title{Merges two Hermite estimators}
\usage{
merge_pair(h_est_obj, hermite_estimator_other)
}
\arguments{
\item{h_est_obj}{A hermite_estimator_univar or hermite_estimator_bivar 
object. 
The first Hermite series based estimator.}

\item{hermite_estimator_other}{A hermite_estimator_univar or
hermite_estimator_bivar object. The second Hermite series based estimator.}
}
\value{
An object of class hermite_estimator_univar or 
hermite_estimator_bivar.
}
\description{
Note that the estimators must be of the same type to be merged i.e. both 
estimators must have a consistent est_type, either "univariate" or 
"bivariate". In addition, the N and standardize arguments must be the same 
for both estimators in order to merge them. Finally, note that exponentially 
weighted estimators cannot be merged. If the Hermite estimators are not 
standardized, the merged estimator will be exactly equivalent to constructing
a single estimator on the data set formed by combining the data sets used to 
update the respective hermite_estimator inputs. If the input Hermite 
estimators are standardized however, then the equivalence will be approximate
but still reasonably accurate in most cases.
}
\examples{
\dontrun{
hermite_est_1 <- hermite_estimator(N = 10, standardize = FALSE, 
observations = rnorm(30))
hermite_est_2 <- hermite_estimator(N = 10, standardize = FALSE, 
observations = rnorm(30))
hermite_merged <- merge_pair(hermite_est_1, hermite_est_2)
}
}
