\name{simulate.hergm}

\alias{simulate.hergm}

\alias{hergm.simulate}

\alias{simulate}

\title{Simulate network}

\description{

The function \code{simulate.hergm} accepts an object of class \code{hergm} as argument and simulates networks.

}

\usage{

\method{simulate}{hergm}(object, 
                         nsim = 1,
                         seed = NULL,
                         max_number = NULL,
                         indicator = NULL,
                         eta = NULL,
                         sample_size = 1,
                         verbose = 0,
                         \dots)
}

\arguments{

\item{object}{either object of class \code{hergm} or formula of the form \code{network ~ terms}; objects of class \code{hergm} can be generated by function \code{hergm}; \code{network} is an object of class \code{network} and can be created by calling the function \code{network}; possible terms can be found in \code{ergm.terms} and \code{hergm.terms}.}

\item{nsim}{redundant, but ensures that the \code{simulate} method is compatible with the \code{simulate} method of \code{R} package \code{stats}.}

\item{seed}{redundant, but ensures that the \code{simulate} method is compatible with the \code{simulate} method of \code{R} package \code{stats}.}

\item{max_number}{maximum number of blocks.}

\item{indicator}{indicators of block memberships of nodes.}

\item{eta}{\code{ergm.terms} and \code{hergm.terms} parameters.}

\item{sample_size}{number of networks to be simulated.}

\item{verbose}{if \code{verbose == -1}, no console output; if \code{verbose == 0}, short console output; if \code{verbose == +1}, long console output.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

The function \code{simulate.hergm} returns the simulated networks in the form of edge lists.

}

\seealso{hergm, ergm.terms, hergm.terms, gof.hergm}

\references{

Schweinberger, M. and P. Luna (2018). HERGM: Hierarchical exponential-family random graph models. Journal of Statistical Software, 85, 1--39.

}

\examples{
\dontrun{data(example)

# Simulate network given 'object' of class 'hergm':
object <- hergm(d ~ edges_ij + triangle_ijk)
simulate.hergm(object) 

# Simulate network given 'formula':
indicator <- c(rep.int(1, 10), rep.int(2, 10))
eta <- c(-1, -1, -2, 1, 1, 0)
simulate.hergm(d ~ edges_ij + triangle_ijk, max_number = 2, indicator = indicator, eta = eta)
}
}

