# critical value of Roy's largest root test

#lambda.crit <- function(alpha, p, dfh, dfe){
#    d <- max(p, dfh)
#    nu <- dfe - d + dfh
#    (d/nu) * qf(alpha, d, nu, lower.tail=FALSE)
#    }

lambda.crit <- function(alpha, p, dfh, dfe, test.statistic=c("Roy", "HLT", "Hotelling-Lawley")){
	test.statistic <- match.arg(test.statistic)
	switch(test.statistic,
		Roy = Roy.crit(alpha, p, dfh, dfe),
		HLT = HLT.crit(alpha, p, dfh, dfe),
		"Hotelling-Lawley" = HLT.crit(alpha, p, dfh, dfe)
		)
}
# see: http://wiki.math.yorku.ca/index.php/Statistics:_Ellipses
## Critical value for \lambda_1 in Roy test
Roy.crit <- function(alpha, p, dfh, dfe){
    df1 <- max(p, dfh)
    df2 <- dfe - df1 + dfh
    (df1/df2) * qf(alpha, df1, df2, lower.tail=FALSE)
}

## Critical value for \bar{\lambda_i} in HLT test
HLT.crit <- function ( alpha, p, dfh, dfe) {
	s <- min(p, dfh)
	m <- (abs(p-dfh)-1)/2
	n <- (dfe-p-1)/2
	df1 <- 2*m + s + 1
	df2 <- 2*(s*n +1)
  s * (df1/df2) * qf(alpha, df1, df2, lower.tail=FALSE)	
}


# extend HE parmeters for given number of terms
#   return vector in the form H1, H2, ..., E
he.rep <- function (x, n) {
    if (length(x) < 2) x <- rep(x, 2)
    x <- c(rep(x[-1], n)[1:n], x[1])
    return(x)
	}
