% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zonal_mask.R
\name{zonal_mask}
\alias{zonal_mask}
\title{Divide a raster image into four stacks which are used as masks.}
\usage{
zonal_mask(img)
}
\arguments{
\item{img}{SpatRaster. The input single layer image generated from \code{\link[terra:rast]{terra::rast()}}.}
}
\value{
A 4-layers stacks of image masks
}
\description{
This function imports a SpatRaster image using \code{\link[terra:rast]{terra::rast()}} functionality, and divide into four masks, using the image centre and borders as vertices.
The four zonal masks are then returned as a RasterStack.
}
\examples{
image<-system.file('extdata/circular_coolpix4500+FC-E8_chestnut.jpg',package='hemispheR')
zmsk<-zonal_mask(terra::rast(image, lyrs=3))
terra::plot(zmsk,col=gray.colors(5),main=c('N','W','S','E'))

}
