% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{colByValue}
\alias{colByValue}
\title{colByValue}
\usage{
colByValue(x, col, range = NA, breaks = NA, cex.axis = 2, las = 1, ...)
}
\arguments{
\item{x}{matrix with values.}

\item{col}{a list of colors such as that generated by \code{\link{rainbow}}, \code{\link{heat.colors}}, \code{\link{topo.colors}}, \code{\link{terrain.colors}} or similar functions.}

\item{range}{the range of x. values out of the range will be changed to the max or min value of the range.}

\item{breaks}{either a numeric vector of two or more unique cut points or a single number (greater than or equal to 2) giving the number of intervals into which x is to be cut.}

\item{las}{numeric in {0,1,2,3}; the style of axis labels.}

\item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex.}

\item{...}{additional arguments passed on to \code{\link{image}} function to generate the color bar.}
}
\value{
A matrix with colors.
}
\description{
The function colByValue convert the values in matrix into colors
}
\examples{
temp<-rnorm(1000)
col<-colByValue(temp,col=colorRampPalette(c('chartreuse4','white','firebrick'))(1024),range=c(-2,2))
col<-colByValue(temp,col=colorRampPalette(c('chartreuse4',
'white','firebrick'))(5),breaks=c(-5,-1,-0.1,0.1,1,5),cex.axis=0.8)
}

