% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-hai-scale-zero-one.R
\name{hai_scale_zero_one_augment}
\alias{hai_scale_zero_one_augment}
\title{Augment Function Scale Zero One}
\usage{
hai_scale_zero_one_augment(.data, .value, .names = "auto")
}
\arguments{
\item{.data}{The data being passed that will be augmented by the function.}

\item{.value}{This is passed \code{\link[rlang:nse-defuse]{rlang::enquo()}} to capture the vectors you want
to augment.}

\item{.names}{This is set to 'auto' by default but can be a user supplied
character string.}
}
\value{
An augmented tibble
}
\description{
Takes a numeric vector and will return a vector that has been scaled from \verb{[0,1]}
}
\details{
Takes a numeric vector and will return a vector that has been scaled from \verb{[0,1]}
The input vector must be numeric. The computation is fairly straightforward.
This may be helpful when trying to compare the distributions of data where a
distribution like beta from the \code{fitdistrplus} package which requires data to be
between 0 and 1

\deqn{y[h] = (x - min(x))/(max(x) - min(x))}

This function is intended to be used on its own in order to add columns to a
tibble.
}
\examples{
df <- data.frame(x = rnorm(100, 2, 1))
hai_scale_zero_one_augment(df, x)

}
\seealso{
Other Augment Function: 
\code{\link{hai_fourier_augment}()},
\code{\link{hai_fourier_discrete_augment}()},
\code{\link{hai_hyperbolic_augment}()},
\code{\link{hai_polynomial_augment}()},
\code{\link{hai_winsorized_move_augment}()},
\code{\link{hai_winsorized_truncate_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Augment Function}
