% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape_data.R
\name{scrape_groups_by_category}
\alias{scrape_groups_by_category}
\title{Scrape groups by category}
\usage{
scrape_groups_by_category(cat, post_number_per_group = NULL, ...)
}
\arguments{
\item{cat}{The category name (lower case, replace space with -) or category URL}

\item{post_number_per_group}{The number of random posts to scrape per group. Default is NULL, which means scrape the total number of posts in each group}

\item{...}{optional arguments to FUN.}
}
\value{
A data frame
}
\description{
Get posts and all the replies to the posts from groups of a category by entering category name or URL
}
\examples{

\donttest{
## Get the posts data of groups whose names starting with the letter "a" and "z"
scrape_groups_by_category(cat = "health-promotion", post_number_per_group = 1)
cat_url = "https://patient.info/forums/categories/health-promotion-17"
scrape_groups_by_category(cat = cat_url, post_number_per_group = 1)
}

}
