% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_hcai_missing.R
\name{step_missing}
\alias{step_missing}
\title{Clean NA values from categorical/nominal variables}
\usage{
step_missing(recipe, ..., role = NA, trained = FALSE,
  na_percentage = NULL, skip = FALSE)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{?recipes::selections()} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the number of NA values have been
counted in preprocessing.}

\item{na_percentage}{A named numeric vector of NA percentages. This
is \code{NULL} until computed by \code{prep.recipe()}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked?}
}
\value{
An updated version of \code{recipe} with the new step
 added to the sequence of existing steps (if any). For the
 \code{tidy} method, a tibble with columns \code{terms} (the
 selectors or variables selected) and \code{value} (the
 NA counts).
}
\description{
\code{step_missing} creates a specification of a recipe that
 will replace NA values with a new factor level, \code{missing}.
}
\details{
NA values are counted when the recipe is trained using
\code{prep.recipe}. \code{bake.recipe} then fills in the missing values for
the new data.
}
\examples{
library(recipes)
n = 100
d <- tibble::tibble(encounter_id = 1:n,
                    patient_id = sample(1:20, size = n, replace = TRUE),
                    hemoglobin_count = rnorm(n, mean = 15, sd = 1),
                    hemoglobin_category = sample(c("Low", "Normal", "High", NA),
                                                 size = n, replace = TRUE),
                    disease = ifelse(hemoglobin_count < 15, "Yes", "No")
)

# Initialize
my_recipe <- recipe(disease ~ ., data = d)

# Create recipe
my_recipe <- my_recipe \%>\%
  step_missing(all_nominal())
my_recipe

# Train recipe
trained_recipe <- prep(my_recipe, training = d)

# Apply recipe
data_modified <- bake(trained_recipe, newdata = d)
}
