% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr.conf.R
\name{hdrconf}
\alias{hdrconf}
\title{HDRs with confidence intervals}
\usage{
hdrconf(x, den, prob = 95, conf = 95)
}
\arguments{
\item{x}{Numeric vector containing data.}

\item{den}{Density of data as list with components \code{x} and \code{y}.}

\item{prob}{Probability coverage for for HDRs.}

\item{conf}{Confidence for limits on HDR.}
}
\value{
\code{hdrconf} returns list containing the following components:
\item{hdr}{Highest density regions} \item{hdr.lo}{Highest density regions
corresponding to lower confidence limit.} \item{hdr.hi}{Highest density
regions corresponding to upper confidence limit.} \item{falpha}{Values of
\eqn{f_\alpha}{f[alpha]} corresponding to HDRs.} \item{falpha.ci}{Values of
\eqn{f_\alpha}{f[alpha]} corresponding to lower and upper limits.}
}
\description{
Calculates Highest Density Regions with confidence intervals.
}
\examples{

x <- c(rnorm(100,0,1),rnorm(100,4,1))
den <- density(x,bw=hdrbw(x,50))
trueden <- den
trueden$y <- 0.5*(exp(-0.5*(den$x*den$x)) + exp(-0.5*(den$x-4)^2))/sqrt(2*pi)
sortx <- sort(x)

par(mfcol=c(2,2))
for(conf in c(50,95))
{
    m <- hdrconf(sortx,trueden,conf=conf)
    plot(m,trueden,main=paste(conf,"\% HDR from true density"))
    m <- hdrconf(sortx,den,conf=conf)
    plot(m,den,main=paste(conf,"\% HDR from empirical density\\n(n=200)"))
}

}
\references{
Hyndman, R.J. (1996) Computing and graphing highest density
regions \emph{American Statistician}, \bold{50}, 120-126.
}
\seealso{
\code{\link{hdr}}, \code{\link{plot.hdrconf}}
}
\author{
Rob J Hyndman
}
\keyword{distribution}
\keyword{smooth}
