% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gmus.R
\name{plot.gmus}
\alias{plot.gmus}
\title{Plot the estimates returned by gmus and mus}
\usage{
\method{plot}{gmus}(x, ...)
}
\arguments{
\item{x}{An object of class gmus}

\item{...}{Other arguments to plot (not used).}
}
\description{
Plot the number of nonzero coefficients along a range of delta
  values if delta has length larger than 1, or the estimated coefficients if
  delta has length 1.
}
\examples{
# Example with linear regression
set.seed(1)
# Number of samples
n <- 100
# Number of covariates
p <- 50
# True (latent) variables
X <- matrix(rnorm(n * p), nrow = n)
# Measurement matrix (this is the one we observe)
W <- X + matrix(rnorm(n*p, sd = 0.4), nrow = n, ncol = p)
# Coefficient vector
beta <- c(seq(from = 0.1, to = 1, length.out = 5), rep(0, p-5))
# Response
y <- X \%*\% beta + rnorm(n, sd = 1)
# Run the MU Selector
mus1 <- mus(W, y)
# Draw an elbow plot to select delta
plot(mus1)

# Now, according to the "elbow rule", choose the final
# delta where the curve has an "elbow".
# In this case, the elbow is at about delta = 0.08, so
# we use this to compute the final estimate:
mus2 <- mus(W, y, delta = 0.08)
# Plot the coefficients
plot(mus2)

}
