% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{plot_marker_trajectories,hbr-method}
\alias{plot_marker_trajectories}
\alias{plot_marker_trajectories,hbr-method}
\alias{plot_marker_trajectories.hbr}
\title{Method to visualize the trajectories for all markers in a haplotype-block}
\usage{
\S4method{plot_marker_trajectories}{hbr}(object, hbr_id, ylim = c(0, 1),
  loc.col = T, tp.cor = T)
}
\arguments{
\item{object}{object of class \code{hbr}}

\item{hbr_id}{the id of the haplotype-block, for which the marker trajectories 
should be plotted.}

\item{ylim}{numeric vector with two elements specifying the limits of the y-axis.}

\item{loc.col}{boolean indicating if trajectories should be coloured ranging from
red over blue to yellow according to their location on the chromosome (default: TRUE).}

\item{tp.cor}{Boolean indicating if only the time points used for calaculating
correlations \code{use.libs} are shown (tp.cor=T) or all time points present in the
data set are shown (tp.cor=F).}
}
\description{
Method to visualize the trajectories for all markers in a haplotype-block
}
\details{
The method operates on \code{\link{hbr}} objects and plots the trajectories
of all markers in a haplotype-block in all replicates.
Note: As blocks can span a wide range along the genome, it is not expected that 
trajectories within a block stay very similar. Changing location along the genome 
can be indicated with loc.col=T.
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{summary.hbr}} \code{\link{plot.hbr}} 
\code{\link{plot_cluster_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{inspect_window_dbScan}} \code{\link{number_hbr}}
}

