% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haploreg.R
\name{queryHaploreg}
\alias{queryHaploreg}
\title{This function queries Haploreg web-based tool and returns results.}
\usage{
queryHaploreg(query = NULL, file = NULL, study = NULL, ldThresh = 0.8,
  ldPop = "EUR", epi = "vanilla", cons = "siphy", genetypes = "gencode",
  url = "http://archive.broadinstitute.org/mammals/haploreg/haploreg.php",
  verbose = FALSE)
}
\arguments{
\item{query}{Query (a vector of rsIDs).}

\item{file}{A text file (one refSNP ID per line).}

\item{study}{A particular study. See function \code{getStudyList(...)}.
Default: \code{NULL}.}

\item{ldThresh}{LD threshold, r2 (select NA to only show query variants). 
Default: 0.8.}

\item{ldPop}{1000G Phase 1 population for LD calculation. 
Can be: "AFR", "AMR", "ASN". Default: "EUR".}

\item{epi}{Source for epigenomes. 
Possible values: \code{vanilla} for ChromHMM (Core 15-state model);
\code{imputed} for ChromHMM (25-state model using 12 imputed marks);
\code{methyl} for H3K4me1/H3K4me3 peaks;
\code{acetyl} for H3K27ac/H3K9ac peaks.
Default: \code{vanilla}.}

\item{cons}{Mammalian conservation algorithm. 
Possible values: \code{gerp} for GERP,
\code{siphy} for SiPhy-omega,
\code{both} for both.
Default: \code{siphy}.}

\item{genetypes}{Show position relative to.
Possible values: \code{gencode} for Gencode genes;
\code{refseq} for RefSeq genes;
\code{both} for both.
Default: \code{gencode}.}

\item{url}{Haplotype url address. 
Default: <http://archive.broadinstitute.org/mammals/haploreg/haploreg.php>}

\item{verbose}{Verbosing output. Default: FALSE.}
}
\value{
A data frame (table) with results similar to 
Haploreg uses.
}
\description{
This function queries Haploreg web-based tool and returns results.
}
\examples{
data <- queryHaploreg(c("rs10048158","rs4791078"))
head(data)
}

