% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bill_publications.R
\name{bill_publications}
\alias{bill_publications}
\alias{hansard_bill_publications}
\title{Bill Publications}
\usage{
bill_publications(ID = NULL, publication_type = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case",
  verbose = FALSE)

hansard_bill_publications(ID = NULL, publication_type = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case",
  verbose = FALSE)
}
\arguments{
\item{ID}{The ID of a specific bill to return publications for.
If \code{NULL}, returns all bill publications subject to other parameters.
Defaults to \code{NULL}.}

\item{publication_type}{The type of bill publication to return, in the form
of a string. For a character vector of bill publication types, see
\code{\link[=bill_publication_types]{bill_publication_types()}}. If \code{NULL}, returns all
publications of all types, subject to other parameters.
Defaults to \code{NULL}.}

\item{start_date}{Only includes bill publications on or after this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to \code{'1900-01-01'}.}

\item{end_date}{Only includes bill publicationson or before this date.
Accepts character values in \code{'YYYY-MM-DD'} format, and objects of
class \code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or
anything else that can be coerced to a date with \code{as.Date()}.
Defaults to the current system date.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on bill publications.
}
\description{
Returns details of all publications associated with a specific bill
or all bills.
}
\examples{
\dontrun{
# Requesting a specific publication
x <- bill_publications(ID = 752025)

# Requesting all publications after a given date
y <- bill_publications(start_date = "2018-01-01")
}
}
\seealso{
\code{\link[=bill_stage_types]{bill_stage_types()}}

\code{\link[=bills]{bills()}}

\code{\link[=bill_publication_types]{bill_publication_types()}}
}
