% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_analysis.R
\name{calculate_accuracy}
\alias{calculate_accuracy}
\title{Calculate Accuracy}
\usage{
calculate_accuracy(analysis)
}
\arguments{
\item{analysis}{Writership analysis output by
\code{\link{analyze_questioned_documents}}}
}
\value{
The model's accuracy on the test set as a number
}
\description{
Fit a model with \code{\link[=fit_model]{fit_model()}} and calculate posterior probabilities of
writership with \code{\link[=analyze_questioned_documents]{analyze_questioned_documents()}} of a set of test documents
where the ground truth is known. Then use \code{calculate_accuracy()} to measure
the accuracy of the fitted model on the test documents. Accuracy is calculated as
the average posterior probability assigned to the true writer.
}
\examples{
# calculate the accuracy for example analysis performed on test documents and a model with 1 chain
calculate_accuracy(example_analysis)

\dontrun{
main_dir <- "/path/to/main_dir"
test_images_dir <- "/path/to/test_images"
analysis <- analyze_questioned_documents(
  main_dir = main_dir,
  questioned_docs = test_images_dir,
  model = model,
  num_cores = 2,
  writer_indices = c(2, 5),
  doc_indices = c(7, 18)
)
calculate_accuracy(analysis)
}

}
