% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibtex_writer.R
\name{bibtex_writer}
\alias{bibtex_writer}
\title{bibtex writer}
\usage{
bibtex_writer(z, key = NULL)
}
\arguments{
\item{z}{an object of class \code{handl}; see \link{handl} for more}

\item{key}{(character) optional bibtex key to use. if \code{NULL} we
attempt try the following fields in order: \code{key}, \code{identifier},
\code{id}, \code{doi}. if you pass in ouput from \code{\link[=bibtex_reader]{bibtex_reader()}} you're
likely to have a \code{key} field, but otherwise probably not}
}
\value{
an object of class \code{BibEntry}
}
\description{
bibtex writer
}
\examples{
(z <- system.file('extdata/citeproc.json', package = "handlr"))
(tmp <- citeproc_reader(z))
bibtex_writer(z = tmp)
cat(bibtex_writer(z = tmp), sep = "\n")

# give a bibtex key
cat(bibtex_writer(tmp, "foobar89"), sep = "\n")

# many at once
if (requireNamespace("bibtex", quietly=TRUE)) {
(z <- system.file('extdata/bib-many.bib', package = "handlr"))
out <- bibtex_reader(x = z)
bibtex_writer(out)
}
}
\seealso{
Other writers: 
\code{\link{cff_writer}()},
\code{\link{citeproc_writer}()},
\code{\link{codemeta_writer}()},
\code{\link{rdf_xml_writer}()},
\code{\link{ris_writer}()},
\code{\link{schema_org_writer}()}

Other bibtex: 
\code{\link{bibtex_reader}()}
}
\concept{bibtex}
\concept{writers}
