% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.nlsfit.R
\name{parametric.bootstrap.cov}
\alias{parametric.bootstrap.cov}
\title{Parametric bootstrap with covariance}
\usage{
parametric.bootstrap.cov(boot.R, x, cov, seed)
}
\arguments{
\item{boot.R}{numeric. Number of bootstrap samples to generate.}

\item{x}{numeric vector. Actual values for the data.}

\item{cov}{numeric matrix, square, length of \code{x} or missing. Covariance
between the various variables in the vector \code{x}.}

\item{seed}{integer. Seed to use for the random number generation. If it is
missing, the seed will not be set to any particular value. If there was a
default value, all results would be exactly correlated. So if you want
reproducability by fixing the seeds, make sure you choose different seeds
for independent variables.}
}
\value{
A matrix with as many columns as there are variables in \code{x} and as many rows
as \code{boot.R}.
}
\description{
Parametric bootstrap with covariance
}
\examples{
x <- 1:3
cov <- matrix(c(0.1, 0, 0.01,
                0, 0.15, 0.02,
                0.01, 0.02, 0.2), nrow = 3)
parametric.bootstrap.cov(5, x, cov)
}
\seealso{
Other NLS fit functions: 
\code{\link{bootstrap.nlsfit}()},
\code{\link{parametric.bootstrap}()},
\code{\link{parametric.nlsfit.cov}()},
\code{\link{parametric.nlsfit}()},
\code{\link{plot.bootstrapfit}()},
\code{\link{predict.bootstrapfit}()},
\code{\link{print.bootstrapfit}()},
\code{\link{simple.nlsfit}()},
\code{\link{summary.bootstrapfit}()}
}
\concept{NLS fit functions}
