% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeTemporal.cf.R
\name{dispersion_relation}
\alias{dispersion_relation}
\title{Continuum dispersion relation for CM to lattice frame}
\usage{
dispersion_relation(energy, momentum_d, extent_space, plus = TRUE,
  lattice_disp = FALSE)
}
\arguments{
\item{energy}{\code{double}. CM energy in lattice units, \eqn{aE}.}

\item{momentum_d}{\code{integer}. Total momentum squared of the moving frame in lattice units, \eqn{d^2}.}

\item{extent_space}{\code{integer}. Spatial extent of the lattice as a dimensionless quantity, \eqn{L/a}.}

\item{plus}{Boolean. Sign of a^2 artefacts.}

\item{lattice_disp}{Boolean. Use the lattice dispersion relation instead of the continuum one}
}
\value{
\code{double}. Energy in the lattice frame, \eqn{aW}.
}
\description{
Converts a center of mass (CM) frame energy to the lattice frame using the
continuum dispersion relation.
}
\concept{dispersion relations}
