% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pluck_when.R
\name{pluck_when}
\alias{pluck_when}
\title{Pluck a value based on other criteria}
\usage{
pluck_when(.x, .p, .i = 1, .else = NA)
}
\arguments{
\item{.x}{Vector from which to select value.}

\item{.p}{Logical expression.}

\item{.i}{First TRUE index to return.}

\item{.else}{If no matches from .p, value to return.}
}
\value{
A vector of length 1.
}
\description{
Pluck a value based on other criteria
}
\examples{
library(dplyr)
df <- tibble(
id = c(1, 1, 1, 2, 2, 2, 3, 3),
tested = c("no", "no", "yes", "no", "no", "no", "yes", "yes"),
year = c(2015:2017, 2010:2012, 2019:2020)
)
df \%>\%
 group_by(id) \%>\%
 mutate(year_first_tested = pluck_when(year, tested == "yes"))
}
