% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchyLong.R
\name{hierarchyLong}
\alias{hierarchyLong}
\title{hierarchyLong}
\usage{
hierarchyLong(ee, supv, printTree = TRUE)
}
\arguments{
\item{ee}{A list of values representing employees (e.g. employee IDs).}

\item{supv}{A list of values representing the supervisors of the employees. These values should be
of the same type as the employee values.}

\item{printTree}{Logical indicator to print the calculated data tree to the console.}
}
\value{
data frame
}
\description{
This function takes employee and supervisor
identifiers (name, ID, etc.) and returns a long data frame consisting of
one row per employee for every supervisor above them, up to the CEO.

The resulting format is useful for quickly filtering to a specific
part of the workforce that directly and indirectly reports up through
a particular leader.
}
\examples{
ee = c("Dale","Bob","Julie","Susan")
supv = c("Julie","Julie","Susan","George")
hierarchyLong(ee,supv)
}
