% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DataSet.R
\docType{class}
\name{DataSet}
\alias{DataSet}
\alias{DataSet-class}
\alias{h5close,DataSet-method}
\alias{readDataSet}
\alias{readDataSet,DataSet-method}
\alias{writeDataSet}
\alias{writeDataSet,DataSet-method}
\title{The DataSet Class}
\usage{
writeDataSet(.Object, data, dspace = selectDataSpace(.Object, rep(NA_integer_,
  length(.Object@dim)), GetDimensions(data)), transpose = TRUE)

\S4method{writeDataSet}{DataSet}(.Object, data,
  dspace = selectDataSpace(.Object, rep(NA_integer_, length(.Object@dim)),
  GetDimensions(data)), transpose = TRUE)

readDataSet(.Object, dspace = selectDataSpace(.Object))

\S4method{readDataSet}{DataSet}(.Object, dspace = selectDataSpace(.Object))

\S4method{h5close}{DataSet}(.Object)
}
\arguments{
\item{.Object}{DataSet; S4 object of class \code{DataSet};}

\item{data}{object; Object to be stored in HDF5 file, can be either of type
vector, matrix or array.}

\item{dspace}{DataSpace; Data space object used for data selection.}

\item{transpose}{logical; Determine if data object (if is array) should be
transposed.}

\item{...}{additional arguments passed to \code{\link{c}}.}
}
\description{
\code{DataSet}s are used to store data objects in the HDF5 tree. Data objects
contain homogeneous data of one type like numeric, integer or character and
can be subsetted, extended and enriched with Attributes (see
\code{\link{DataSet-Subset}}, \code{\link{DataSet-Extend}} and
\code{\link{H5Location-Attribute}}). Although subsetting operators provide a
convenient way to handle \code{DataSet} objects the S4 methods described in
this section are used under the hood and give more control. Especially
for big \code{DataSet}s it can be advantageous to use these methods with
\code{\link{DataSpace}} objects including hyperslab selections.
}
\references{
\url{https://www.hdfgroup.org/HDF5/doc/H5.intro.html#Intro-ODatasets}
}

