% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_coordinates.R
\name{get_local_h3}
\alias{get_local_h3}
\title{Get H3 cell from local i, j coordinates}
\usage{
get_local_h3(origin = NULL, i = NULL, j = NULL, simple = TRUE)
}
\arguments{
\item{origin}{Character; 15-character cell index generated by H3. A vector of
indexes can also be supplied.}

\item{i}{a single i coordinate or vector of same, generated by
\code{\link[h3jsr:get_local_ij]{get_local_ij}}}

\item{j}{a single j coordinate or vector of same, generated by
\code{\link[h3jsr:get_local_ij]{get_local_ij}}}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
If `simple = TRUE`, a character vector of destination H3 cells.
  If not, a data frame containing columns origin, i, j, destination.
}
\description{
This function returns H3 destination cells for local i, j coordinate
pairs anchored by an H3 origin cell.
}
\note{
\itemize{
  \item{The coordinate space used by this function may have deleted regions
  or warping due to pentagonal distortion.}
  \item{Coordinates are only comparable if they come from the same origin
  cell.}
  \item{Failure may occur if the destination is too far away from the origin
  or if the destination is on the other side of a pentagon.}
  \item{This function is experimental, and its output is not guaranteed to be
  compatible across different versions of H3.}
 }
}
\examples{
# Get local coordinates for a nearby cell
local <- get_local_ij(origin = '86be8d12fffffff', destination = '86be8d127ffffff')

# Convert back to destination cell
get_local_h3(origin = '86be8d12fffffff', i = local[, 1], j = local[, 2])

}
