% Generated by roxygen2 (4.0.2): do not edit by hand
\name{apply}
\alias{apply}
\title{Apply on H2O Datasets}
\usage{
apply(X, MARGIN, FUN, ...)
}
\arguments{
\item{X}{an H2OFrame object on which \code{apply} will operate.}

\item{MARGIN}{the vector on which the function will be applied over, either
\code{1} for rows or \code{2} for columns.}

\item{FUN}{the function to be applied.}

\item{\dots}{optional arguments to \code{FUN}.}
}
\value{
Produces a new H2OFrame of the output of the applied
        function. The output is stored in H2O so that it can be used in
        subsequent H2O processes.
}
\description{
Method for apply on H2OFrame objects.
}
\examples{
\donttest{
h2o.init()
irisPath = system.file("extdata", "iris.csv", package="h2o")
iris.hex = h2o.importFile(path = irisPath, destination_frame = "iris.hex")
summary(apply(iris.hex, 2, sum))
}
}
\seealso{
\link[base]{apply} for the base generic
}

