% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.null_deviance}
\alias{h2o.null_deviance}
\title{Retrieve the null deviance}
\usage{
h2o.null_deviance(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} or \linkS4class{H2OModelMetrics}}

\item{train}{Retrieve the training null deviance}

\item{valid}{Retrieve the validation null deviance}

\item{xval}{Retrieve the cross-validation null deviance}
}
\description{
If "train", "valid", and "xval" parameters are FALSE (default), then the training null deviance value is returned. If more
than one parameter is set to TRUE, then a named vector of null deviances are returned, where the names are "train", "valid"
or "xval".
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(prostate_path)
prostate[,2] <- as.factor(prostate[,2])
prostate_glm <- h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"), 
                        training_frame = prostate, family = "binomial", nfolds = 0, 
                        alpha = 0.5, lambda_search = FALSE)
h2o.null_deviance(prostate_glm, train = TRUE)
}
}
