% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.transform,H2OTargetEncoderModel-method}
\alias{h2o.transform,H2OTargetEncoderModel-method}
\title{Applies target encoding to a given dataset}
\usage{
\S4method{h2o.transform}{H2OTargetEncoderModel}(
  model,
  data,
  data_leakage_handling = NULL,
  use_blending = NULL,
  inflection_point = -1,
  smoothing = -1,
  noise = -1,
  seed = -1
)
}
\arguments{
\item{model}{A trained model representing the transformation strategy}

\item{data}{An H2OFrame with data to be transformed}

\item{data_leakage_handling}{Handling of data leakage.
Available options are : ["None", "LeaveOneOut", "KFold"]. Defaults to "None".}

\item{use_blending}{Use blending during the transformation. Respects model settings when not set.}

\item{inflection_point}{Blending parameter. Only effective when blending is enabled.
By default, model settings are respected, if not overridden by this setting.}

\item{smoothing}{Blending parameter. Only effective when blending is enabled.
By default, model settings are respected, if not overridden by this setting.}

\item{noise}{An amount of random noise added to the encoding. This helps prevent overfitting. Defaults to 0.01 * range of response.}

\item{seed}{A random seed used to generate draws from the uniform distribution for random noise. Defaults to -1.}
}
\value{
Returns an H2OFrame object with data transformed.
}
\description{
Applies target encoding to a given dataset
}
