% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.createFrame}
\alias{h2o.createFrame}
\title{Data H2OFrame Creation in H2O}
\usage{
h2o.createFrame(rows = 10000, cols = 10, randomize = TRUE,
  value = 0, real_range = 100, categorical_fraction = 0.2,
  factors = 100, integer_fraction = 0.2, integer_range = 100,
  binary_fraction = 0.1, binary_ones_fraction = 0.02,
  time_fraction = 0, string_fraction = 0, missing_fraction = 0.01,
  response_factors = 2, has_response = FALSE, seed,
  seed_for_column_types)
}
\arguments{
\item{rows}{The number of rows of data to generate.}

\item{cols}{The number of columns of data to generate. Excludes the response column if \code{has_response = TRUE}.}

\item{randomize}{A logical value indicating whether data values should be randomly generated. This must be TRUE if either \code{categorical_fraction} or \code{integer_fraction} is non-zero.}

\item{value}{If \code{randomize = FALSE}, then all real-valued entries will be set to this value.}

\item{real_range}{The range of randomly generated real values.}

\item{categorical_fraction}{The fraction of total columns that are categorical.}

\item{factors}{The number of (unique) factor levels in each categorical column.}

\item{integer_fraction}{The fraction of total columns that are integer-valued.}

\item{integer_range}{The range of randomly generated integer values.}

\item{binary_fraction}{The fraction of total columns that are binary-valued.}

\item{binary_ones_fraction}{The fraction of values in a binary column that are set to 1.}

\item{time_fraction}{The fraction of randomly created date/time columns.}

\item{string_fraction}{The fraction of randomly created string columns.}

\item{missing_fraction}{The fraction of total entries in the data frame that are set to NA.}

\item{response_factors}{If \code{has_response = TRUE}, then this is the number of factor levels in the response column.}

\item{has_response}{A logical value indicating whether an additional response column should be pre-pended to the final H2O data frame. If set to TRUE, the total number of columns will be \code{cols+1}.}

\item{seed}{A seed used to generate random values when \code{randomize = TRUE}.}

\item{seed_for_column_types}{A seed used to generate random column types when \code{randomize = TRUE}.}
}
\value{
Returns an H2OFrame object.
}
\description{
Creates a data frame in H2O with real-valued, categorical, integer, and binary columns specified by the user.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
hf <- h2o.createFrame(rows = 1000, cols = 100, categorical_fraction = 0.1,
                      factors = 5, integer_fraction = 0.5, integer_range = 1,
                      has_response = TRUE)
head(hf)
summary(hf)

hf <- h2o.createFrame(rows = 100, cols = 10, randomize = FALSE, value = 5,
                      categorical_fraction = 0, integer_fraction = 0)
summary(hf)
}
}
