% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.runif}
\alias{h2o.runif}
\title{Produce a Vector of Random Uniform Numbers}
\usage{
h2o.runif(x, seed = -1)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}

\item{seed}{A random seed used to generate draws from the uniform distribution.}
}
\value{
A vector of random, uniformly distributed numbers. The elements are between 0 and 1.
}
\description{
Creates a vector of random uniform numbers equal in length to the length of the specified H2O
dataset.
}
\examples{
\donttest{
library(h2o)
localH2O = h2o.init()
prosPath = system.file("extdata", "prostate.csv", package="h2o")
prostate.hex = h2o.importFile(localH2O, path = prosPath, destination_frame = "prostate.hex")
s = h2o.runif(prostate.hex)
summary(s)

prostate.train = prostate.hex[s <= 0.8,]
prostate.train = h2o.assign(prostate.train, "prostate.train")
prostate.test = prostate.hex[s > 0.8,]
prostate.test = h2o.assign(prostate.test, "prostate.test")
nrow(prostate.train) + nrow(prostate.test)
}
}

