% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.importFile}
\alias{h2o.importFile}
\alias{h2o.importFolder}
\alias{h2o.importHDFS}
\alias{h2o.importURL}
\alias{h2o.uploadFile}
\title{Import Files into H2O}
\usage{
h2o.importFolder(path, conn = h2o.getConnection(), pattern = "",
  destination_frame = "", parse = TRUE, header = NA, sep = "",
  col.names = NULL, na.strings = NULL)

h2o.importURL(path, conn = h2o.getConnection(), destination_frame = "",
  parse = TRUE, header = NA, sep = "", col.names = NULL,
  na.strings = NULL)

h2o.importHDFS(path, conn = h2o.getConnection(), pattern = "",
  destination_frame = "", parse = TRUE, header = NA, sep = "",
  col.names = NULL, na.strings = NULL)

h2o.uploadFile(path, conn = h2o.getConnection(), destination_frame = "",
  parse = TRUE, header = NA, sep = "", col.names = NULL,
  col.types = NULL, na.strings = NULL, progressBar = FALSE)
}
\arguments{
\item{path}{The complete URL or normalized file path of the file to be
imported. Each row of data appears as one line of the file.}

\item{conn}{an \linkS4class{H2OConnection} class object.}

\item{pattern}{(Optional) Character string containing a regular expression to match file(s) in
the folder.}

\item{destination_frame}{(Optional) The unique hex key assigned to the imported file. If
none is given, a key will automatically be generated based on the URL
path.}

\item{parse}{(Optional) A logical value indicating whether the file should be
parsed after import.}

\item{header}{(Optional) A logical value indicating whether the first line of
the file contains column headers. If left empty, the parser will try
to automatically detect this.}

\item{sep}{(Optional) The field separator character. Values on each line of
the file are separated by this character. If \code{sep = ""}, the
parser will automatically detect the separator.}

\item{col.names}{(Optional) A \linkS4class{H2ORawData} or
\linkS4class{H2OFrame} (\code{version = 2}) object containing a single
delimited line with the column names for the file.}

\item{na.strings}{(Optional) H2O will interpret these strings as missing.}

\item{col.types}{(Optional) A vector to specify whether columns should be
forced to a certain type upon import parsing.}

\item{progressBar}{(Optional) When FALSE, tell H2O parse call to block
synchronously instead of polling.  This can be faster for small
datasets but loses the progress bar.}
}
\description{
Imports files into an H2O cloud. The default behavior is to pass-through to the parse phase
automatically.
}
\details{
Other than \code{h2o.uploadFile}, if the given path is relative, then it will be relative to the
start location of the H2O instance. Additionally, the file must be on the same machine as the H2O
cloud. In the case of \code{h2o.uploadFile}, a relative path will resolve relative to the working
directory of the current R session.

Import an entire directory of files. If the given path is relative, then it
will be relative to the start location of the H2O instance. The default
behavior is to pass-through to the parse phase automatically.

\code{h2o.importURL} and \code{h2o.importHDFS} are both deprecated functions. Instead, use
\code{h2o.importFile}
}
\examples{
localH2O = h2o.init(ip = "localhost", port = 54321, startH2O = TRUE)
prosPath = system.file("extdata", "prostate.csv", package = "h2o")
prostate.hex = h2o.uploadFile(localH2O, path = prosPath, destination_frame = "prostate.hex")
class(prostate.hex)
summary(prostate.hex)
}

