% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{buildOneFacRes}
\alias{buildOneFacRes}
\title{Build a model suitable for a single factor residual genome-wide association study}
\usage{
buildOneFacRes(phenoData, itemNames, factor = F, res = itemNames,
  covariates = NULL, ..., fitfun = c("WLS", "ML"), minMAF = 0.01,
  modelType = c("RAM", "LISREL"), gxe = NULL)
}
\arguments{
\item{phenoData}{phenotype data with one individual per row}

\item{itemNames}{a vector of phenotypic item names that load on the latent factor}

\item{factor}{whether to estimate a regression from the SNP to the latent factor (default FALSE)}

\item{res}{character vector. Which indicators to estimate a regression to}

\item{covariates}{a vector of data column names to use as covariates}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfun}{the name of the fit function to optimize}

\item{minMAF}{minimum minor allele frequency. Only used when \code{fitfun=WLS}}

\item{modelType}{whether to use the RAM or LISREL parameterization}

\item{gxe}{a vector of data column names. Creates additional data
columns named paste0('snp_',columnName) that are the
product of the SNP and the data in columnName}
}
\value{
A \link[OpenMx:MxModel-class]{MxModel}
}
\description{
Build a model suitable for a single factor residual genome-wide association study
}
\details{
You can pass the result of this function to \link{GWAS} to run a GWAS.

Ordinal indicator thresholds are setup by
\link{setupThresholds}. Covariates adjustments are setup by
\link{setupCovariates}.
You can plot the model using \link[OpenMx]{omxGraphviz}.
}
\examples{
pheno <- list()
for (i in 1:5) pheno[[paste0('i',i)]] <- rnorm(500)
pheno <- as.data.frame(pheno)
buildOneFacRes(pheno, colnames(pheno))
}
\seealso{
Other model builder: \code{\link{buildOneFac}},
  \code{\link{buildOneItem}}, \code{\link{buildTwoFac}}
}
\concept{model builder}
