% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recursive_apply.R
\name{recursive_apply}
\alias{recursive_apply}
\title{Simple rapply version that deals with NULL values.}
\usage{
recursive_apply(x, fn)
}
\arguments{
\item{x}{A list (of potentially many nested lists).}

\item{fn}{A function of a single argument.}
}
\value{
A list whose non-list elements have been replaced by the result of
  applying \code{fn}.
}
\description{
Like \code{\link[base]{rapply}}, \code{recursive_apply} is a recursive
version \code{\link[base]{lapply}} but contrary to
\code{\link[base]{rapply}}, \code{recursive_apply} does not ignore
\code{\link[base]{NULL}} values. Each element of the list which is not itself
a list is replaced by the result of applying \code{fn}. If down the line
there are data.frames, then their class is preserved.
}
\keyword{internal}
